<?php

namespace App\Services\Gateway;

use App\Services\Auth;
use App\Services\Config;

use App\Models\Paylist;

class MotionPay extends AbstractPayment
{
    
    public function purchase($request, $response, $args)
    {
        $price = $request->getParam('amount');
        $type = $request->getParam('type') ?: 'alipay';
        if ($type == 'wechat') {
            $type = 'wxpay';
        }
        if ($price < 1) {
            return json_encode(['code' => -1, 'msg' => "订单金额不能小于1元"]);
        }
        $user = Auth::getUser();
        $pl = new Paylist();
        $pl->userid = $user->id;
        $pl->total = $price;
        $pl->tradeno = self::generateGuid();
        $pl->save();
        // 组装参数
        $data = [
            "pid"          => trim(Config::get('motionpay_pid')),
            "type"         => $type,
            "notify_url"   => Config::get('baseUrl') . '/payment/notify',
            "return_url"   => Config::get('baseUrl') . '/user/payment/return?out_trade_no=' . $pl->tradeno,
            "out_trade_no" => $pl->tradeno,
            'name'         => 'U' . $user->id,
            "money"        => $price,
            'clientip'     => $this->getClientIp(),
            'device'       => $this->requestIsMobile() ? 'mobile' : '',
        ];
        $url = Config::get('motionpay_apiurl') . 'mapi.php';
        $data['sign_type'] = 'MD5';
        $data['sign'] = $this->sign($data);
        $response = $this->curlAction($url, $data);
        if (empty($response)) {
            return json_encode(['code' => -1, 'msg' => '支付网关LP下单失败，请重试', 'requ' => $url, 'reqd' => $data, 'rsp' => $response]);
        }
    	$result = (array)json_decode($response, true);
        $pay_url = '';
        // 返回支付页面或url
        if (!empty($result['payurl'])) {
            $pay_url = $result['payurl'];
        } elseif (!empty($result['qrcode'])) {
            $pay_url = $result['qrcode'];
        } elseif (!empty($result['urlscheme'])) {
            $pay_url = $result['urlscheme'];
        }
    	if (empty($pay_url)) {
    		return json_encode(['code' => -1, 'msg' => '支付网关LP下单支付链接为空，请重试', 'requ' => $url, 'reqd' => $data, 'rsp' => $response]);
    	}
        return json_encode(['url' => $pay_url, 'code' => 0, 'pid' => $pl->tradeno]);
    }

    public function notify($request, $response, $args)
    {
        if (!$this->verify($request->getParams())) {
    		die('verify sign FAIL');
    	}
    	$this->postPayment($request->getParam('out_trade_no'), 'MotionPay');
    	die('success');
    }

    public function getPurchaseHTML()
    {
        return 1;
    }

    public function getReturnHTML($request, $response, $args)
    {
        // TODO: Implement getReturnHTML() method.
    }

    public function getStatus($request, $response, $args)
    {
        // TODO: Implement getReturnHTML() method.
    }

    private function requestIsMobile() {
        $ua = $ua ?: ($_SERVER['HTTP_USER_AGENT'] ?? '');
        if (empty($ua)) {
            return false;
        }
        $mobile_agents = ["240x320","acer","acoon","acs-","abacho","ahong","airness","alcatel","amoi","android","anywhereyougo.com","applewebkit/525","applewebkit/532","asus","audio","au-mic","avantogo","becker","benq","bilbo","bird","blackberry","blazer","bleu","cdm-","compal","coolpad","danger","dbtel","dopod","elaine","eric","etouch","fly ","fly_","fly-","go.web","goodaccess","gradiente","grundig","haier","hedy","hitachi","htc","huawei","hutchison","inno","ipad","ipaq","ipod","jbrowser","kddi","kgt","kwc","lenovo","lg ","lg2","lg3","lg4","lg5","lg7","lg8","lg9","lg-","lge-","lge9","longcos","maemo","mercator","meridian","micromax","midp","mini","mitsu","mmm","mmp","mobi","mot-","moto","nec-","netfront","newgen","nexian","nf-browser","nintendo","nitro","nokia","nook","novarra","obigo","palm","panasonic","pantech","philips","phone","pg-","playstation","pocket","pt-","qc-","qtek","rover","sagem","sama","samu","sanyo","samsung","sch-","scooter","sec-","sendo","sgh-","sharp","siemens","sie-","softbank","sony","spice","sprint","spv","symbian","tablet","talkabout","tcl-","teleca","telit","tianyu","tim-","toshiba","tsm","up.browser","utec","utstar","verykool","virgin","vk-","voda","voxtel","vx","wap","wellco","wig browser","wii","windows ce","wireless","xda","xde","zte"];
        $is_mobile = false;
        foreach ($mobile_agents as $device) {
            if (stristr($ua, $device)) {
                $is_mobile = true;
                break;
            }
        }
        return $is_mobile;
    }
    
    private function sign(array $params){
        $args = array_filter($params, function ($i, $k){
            if($k != 'sign' && $k != 'sign_type' && !empty($i)) return true;
        }, ARRAY_FILTER_USE_BOTH);
        ksort($args);
        $str = urldecode(http_build_query($args));
        return md5($str . Config::get('motionpay_key'));
    }

    private function verify($data)
    {
    	$signature = !empty($data['sign']) ? $data['sign'] : '';
        $mySign = $this->sign($data);
        return $mySign === $signature;
    }

    private function curlAction(string $url, $body = [])
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4 );
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'User-agent: ' . ($_SERVER['HTTP_USER_AGENT'] ?? ''),
        ]);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
        $output = curl_exec($ch);
        curl_close($ch);
        return $output;
    }

    /**
     * 获取客户端IP
     */
    private function getClientIp() {
        static $final;
        if (!is_null($final)) {
            return $final;
        }
        $ips = array();
        // AZURE-CDN
        if (!empty($_SERVER['HTTP_X_AZURE_CLIENTIP'])) {
            $ips[] = $_SERVER['HTTP_X_AZURE_CLIENTIP'];
        }
        // AWS-CDN
        if (!empty($_SERVER['HTTP_TRUE_CLIENT_IP'])) {
            $ips[] = $_SERVER['HTTP_TRUE_CLIENT_IP'];
        }
        // CF-CDN
        if (!empty($_SERVER['HTTP_CF_CONNECTING_IP'])) {
            $ips[] = $_SERVER['HTTP_CF_CONNECTING_IP'];
        }
        if (!empty($_SERVER['HTTP_ALI_CDN_REAL_IP'])) {
            $ips[] = $_SERVER['HTTP_ALI_CDN_REAL_IP'];
        }
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            $ips[] = $_SERVER['HTTP_CLIENT_IP'];
        }
        if (!empty($_SERVER['HTTP_PROXY_USER'])) {
            $ips[] = $_SERVER['HTTP_PROXY_USER'];
        }
        $real_ip = getenv('HTTP_X_REAL_IP');
        if (!empty($real_ip)) {
            $ips[] = $real_ip;
        }
        if (!empty($_SERVER['REMOTE_ADDR'])) {
            $ips[] = $_SERVER['REMOTE_ADDR'];
        }
        if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            foreach (explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']) as $ip) {
                $ips[] = trim($ip);
            }
        }
        // 选第一个最合法的，或最后一个正常的IP
        foreach ($ips as $ip) {
            $long = ip2long($ip);
            $long && $final = $ip;
            // 排除不正确的或私有IP
            if (!(($long == 0) ||                                       // 不正确的IP或0.0.0.0
                  ($long == -1) ||                                      // PHP4下当IP不正确时会返回-1
                  ($long == 4294967295) ||                              // 255.255.255.255
                  ($long == 2130706433) ||                                // 127.0.0.1
                  (($long >= 167772160) && ($long <= 184549375)) ||   // 10.0.0.0 - 10.255.255.255
                  (($long >= 2886729728) && ($long <= 2887778303)) ||   // 172.16.0.0 - 172.31.255.255
                  (($long >= 3232235520) && ($long <= 3232301055)))) {  // 192.168.0.0 - 192.168.255.255
                $final = long2ip($long);
                break;
            }
        }
        empty($final) && $final = '0.0.0.0';
        return $final;
    }
}
