<?php 

class WC_Gateway_Codepay_Notify
{
	public function __construct($gateway)
	{
	    
		$this ->gateway = $gateway;
		add_action("woocommerce_api_wc_gateway_codepay",array($this,"notify"));
	}

	public function notify()
	{

		require_once("inc/codepay.config.php");
		require_once("lib/codepay_notify.class.php");
		$codepayNotify = new CodepayNotify($data);
		$verify_result = $codepayNotify->verifyAll(); //这里验证的是全部参数 这样软件端也能调试
		if(!$verify_result)
		{
		    //验证失败 返回订单页重新提交
		    return "fail";
		}else{
			//验证价格是否有误
			$this -> DataHandle($_GET);
		}
	}
	
	function DataHandle($data)
	{
		$pay_id = $data['pay_id']; //需要充值的ID 或订单号 或用户名
	    $money = (float)$data['money']; //实际付款金额
	    $price = (float)$data['price']; //订单的原价
	    $type = (int)$data['type']; //支付方式
	    $pay_no = $data['pay_no']; //支付流水号
	    $param = $data['param']; //自定义参数 原封返回 您创建订单提交的自定义参数
	    $pay_time = (int)$data['pay_time']; //付款时间戳
	    $pay_tag = $data['tag']; //支付备注 仅支付宝才有 其他支付方式全为0或空
	    $creat_time = time(); //创建数据的时间戳
	    if ($money <= 0 || empty($pay_id) || $pay_time <= 0 || empty($pay_no)) {
	        return '缺少必要的一些参数'; //测试数据中 唯一标识必须包含这些
	    }
	    //所有验证成功，付款金额正确
	    $order = wc_get_order($pay_id);
	    if (!$order)
	    {
	    	return "订单id获取失败";
	    	exit();
	    }
	    $order_data = $order->get_data();
	    //判断订单状态避免重复处理
	    if ($order_data['status'] != "pending")
	    {
        	return "success";
	    }
	    
	    switch($type)
	   	{
	   		case 1:
	   			$type = "支付宝";
	   			break;
	   		case 2:
	   			$type = "qq钱包";
	   			break;
	   		case 3:
	   			$type = "微信";
	   			break;
	   		default:
	   			$type = "支付宝";
	   	}

	   	if ($price > $money)
	    {
	    	$kong = round(($price - $money), 2);
	    	$msg = '顾客使用码支付-'.$type.'方式付款成功，但仍有'.$kong.'元未结清！请联系此谷歌重新付款。';
	    }elseif ($price < $money)
	    {
	    	$kong = round(($money - $price), 2);
	    	$msg = '顾客使用码支付-'.$type.'方式完成支付，但多付了'.$kong.'元，请联系此顾客退还多余款项。';
	    }else{
	    	$msg = '顾客使用码支付-'.$type.'方式完成支付。';
	    	
	    }
        $order->add_order_note($msg);
        $order->payment_complete();

        //如果全是虚拟商品，直接完成订单
        if($this -> is_All_Virtual($order))
        {
        	$order->update_status('completed');
        }
        return "success";
	}

	//购物车中商品是否全为虚拟商品
	public function is_All_Virtual ($order,$option=false)
	{
	   
		foreach( $order->get_items() as $item ) {
            if ( 'line_item' == $item['type'] ) {
                $_product = $order->get_product_from_item( $item );
                if (!$_product->is_virtual()) {
                    // 这里一旦发现订单内有商品是实物商品，就不用再进行下去了
                    $is_virtual_order = false;            
                    break;
                } else {
                   	$is_virtual_order = true;    
                }
            }
        }
        if ($option)
        {
        	return false;
        }
        return $is_virtual_order;
	}
}
?>