<?php 
class WC_Gateway_Easypay_Notify
{
	public function __construct($gateway)
	{
		$this ->gateway = $gateway;
		add_action("woocommerce_api_wc_gateway_easypay",array($this,"notify"));
	}

	public function notify()
	{
		require_once("inc/easypay.config.php");
		require_once("lib/epay_notify.class.php");
		$alipayNotify = new AlipayNotify($alipay_config);
		$verify_result = $alipayNotify->verifyNotify(); //这里验证的是全部参数 这样软件端也能调试
		if(!$verify_result)
		{
		    return "fail";
		}else{
			$this -> DataHandle($_GET, $return_url);
		}
	}
	
	function DataHandle($data, $return_url)
	{
		$out_trade_no = $_GET['out_trade_no'];
		//彩虹易支付交易号
		$trade_no = $_GET['trade_no'];
		//交易状态
		$trade_status = $_GET['trade_status'];
		//支付方式
		$type = $_GET['type'];
	    if ($_GET['trade_status'] != 'TRADE_SUCCESS') {
	    	return "交易未成功";
	    }
	    //所有验证成功，付款金额正确
	    $order = wc_get_order($out_trade_no);
	    if (!$order)
	    {
	    	return "订单id获取失败";
	    	exit();
	    }
	    $order_data = $order->get_data();

	    //判断订单状态避免重复处理
	    if ($order_data['status'] != "pending")
	    {
	    	header("location: ".$return_url);
        	return "success";
	    }
	    
	    switch($type)
	   	{
	   		case "alipay":
	   			$type = "支付宝";
	   			break;
	   		case "qqpay":
	   			$type = "qq钱包";
	   			break;
	   		case "wxpay":
	   			$type = "微信";
	   			break;
	   		default:
	   			$type = "支付宝";
	   	}
	    $msg = '顾客使用易支付-'.$type.'方式完成支付。';
        $order->add_order_note($msg);
        $order->payment_complete();

        //如果全是虚拟商品，直接完成订单
        if($this -> is_All_Virtual($order))
        {
        	$order->update_status('completed');
        }
        header("location: ".$return_url);
        return "success";
	}

	//购物车中商品是否全为虚拟商品
	public function is_All_Virtual ($order,$option=false)
	{
	   
		foreach( $order->get_items() as $item ) {
            if ( 'line_item' == $item['type'] ) {
                $_product = $order->get_product_from_item( $item );
                if (!$_product->is_virtual()) {
                    // 这里一旦发现订单内有商品是实物商品，就不用再进行下去了
                    $is_virtual_order = false;            
                    break;
                } else {
                   	$is_virtual_order = true;    
                }
            }
        }
        if ($option)
        {
        	return false;
        }
        return $is_virtual_order;
	}
}
?>