<?php 
/*
* Plugin Name: freepay for WooCommerce
* Plugin URI: https://www.mebi.me/232
* Description: 适用于Woocommerce商店的免签约支付集合
* Author: home again
* Version: 2.0
* Author URI: htts://www.mebi.me
* QQ:1059902360
* WeChat Public:互联网小店
 */

// 防止该文件直接被访问
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define('WC_Freepay_URL', plugins_url('', __FILE__));     // 当前插件目录的URI
add_action('plugins_loaded', 'init_freepay_gateway_class');

function init_freepay_gateway_class()
{
	require_once('class-wc-gateway-codepay-zfb.php');
	require_once('class-wc-gateway-codepay-qq.php');
	require_once('class-wc-gateway-codepay-wx.php');
	require_once('class-wc-gateway-easypay-zfb.php');
	require_once('class-wc-gateway-easypay-qq.php');
	require_once('class-wc-gateway-easypay-wx.php');
	require_once('class-wc-gateway-codepay-notify.php');
	require_once('class-wc-gateway-easypay-notify.php');
	global $wc_getway_codepay_zfb;
	global $wc_getway_codepay_qq;
	global $wc_getway_codepay_wx;

	$wc_getway_codepay_zfb = new WC_Gateway_Codepay_zfb();
	$wc_getway_codepay_qq = new WC_Gateway_Codepay_qq();
	$wc_getway_codepay_wx = new WC_Gateway_Codepay_wx();
	$wc_getway_easypay_zfb = new WC_Gateway_Easypay_zfb();
	$wc_getway_easypay_qq = new WC_Gateway_Easypay_qq();
	$wc_getway_easypay_wx = new WC_Gateway_Easypay_wx();
}
	

add_filter('woocommerce_payment_gateways', 'add_codepay_zfb_gateway_class');
function add_codepay_zfb_gateway_class($methods)
{
    $methods[] = 'WC_Gateway_Codepay_zfb';
    return $methods;
}

add_filter('woocommerce_payment_gateways', 'add_codepay_qq_gateway_class');
function add_codepay_qq_gateway_class($methods)
{
    $methods[] = 'WC_Gateway_Codepay_qq';
    return $methods;
}

add_filter('woocommerce_payment_gateways', 'add_codepay_wx_gateway_class');
function add_codepay_wx_gateway_class($methods)
{
    $methods[] = 'WC_Gateway_Codepay_wx';
    return $methods;
}

add_filter('woocommerce_payment_gateways', 'add_easypay_zfb_gateway_class');
function add_easypay_zfb_gateway_class($methods)
{
    $methods[] = 'WC_Gateway_Easypay_zfb';
    return $methods;
}

add_filter('woocommerce_payment_gateways', 'add_easypay_qq_gateway_class');
function add_easypay_qq_gateway_class($methods)
{
    $methods[] = 'WC_Gateway_Easypay_qq';
    return $methods;
}

add_filter('woocommerce_payment_gateways', 'add_easypay_wx_gateway_class');
function add_easypay_wx_gateway_class($methods)
{
    $methods[] = 'WC_Gateway_Easypay_wx';
    return $methods;
}

add_action("admin_menu","create_menu_page");
function create_menu_page()
{
	add_menu_page(('免签约支付'),_('网关设置'),"administrator","freepay_gateway","menuPage",plugins_url("freepay-woocommerce/assets/logo/codepay.jpg"));
};

function menuPage()
{
	require_once("inc/show.php");
	if ($_POST["codepay_app_id"] !== null && $_POST["codepay_app_key"] !== null && $_POST["codepay_return_url"] !== null)
	{
		update_option("codepay_app_id",$_POST['codepay_app_id']);
		update_option("codepay_app_key",$_POST['codepay_app_key']);
		update_option("codepay_return_url", $_POST["codepay_return_url"]);
		$path = plugin_dir_path(__FILE__)."inc/codepay.config.php";
		$arr = array(
			"4" =>'$codepay_id = "'.get_option("codepay_app_id").'";',
			"5" => '$codepay_key = "'.get_option("codepay_app_key").'";',
			"6" => '$return_url = "'.get_option("codepay_return_url").'";'
		);
		//修改码支付id和码支付秘钥
		homeagain($path,$arr);
		//修改支付logo图标
	}
	
	if ($_POST["easypay_app_id"] !== null && $_POST["easypay_app_key"] !== null)
	{
		update_option("easypay_address",$_POST['easypay_address']);
		update_option("easypay_app_id",$_POST['easypay_app_id']);
		update_option("easypay_app_key",$_POST['easypay_app_key']);
		update_option("easypay_return_url",$_POST['easypay_return_url']);
		$path = plugin_dir_path(__FILE__)."inc/easypay.config.php";
		$arr = array(
			"1" =>'$alipay_config["partner"] = "'.get_option("easypay_app_id").'";',
			"2" => '$alipay_config["key"] = "'.get_option("easypay_app_key").'";',
			"12" => '$alipay_config["apiurl"] = "'.get_option("easypay_address").'";',
			"13" => '$return_url = "'.get_option("easypay_return_url").'";'
		);
		//修改码支付id和码支付秘钥
		homeagain($path,$arr);
		//修改支付logo图标
	}
}
?>
